IF exists (select 1 from sys.procedures where name ='P_V_SPED_EST_NF_ENT') 
    BEGIN 
	   DROP PROCEDURE P_V_SPED_EST_NF_ENT 
    END   --  EXEC P_V_SPED_EST_NF_ENT '20200701','20201031','1'
GO
CREATE PROCEDURE P_V_SPED_EST_NF_ENT (@DT_INI DATETIME,@DT_FIM DATETIME ,@CD_FILIAL VARCHAR (MAX) )
AS 
SET NOCOUNT ON
--DROP TABLE #V_SPED_NF_ENT
	   CREATE TABLE #V_SPED_NF_ENT(
		   CD_EMP INT ,
		   CD_FILIAL INT ,
		   CD_DOC INT ,
		   IND_OPER INT ,
		   IND_EMIT INT ,
		   CD_ORIG INT NULL,
		   COD_MOD VARCHAR(30) ,
		   TP_SR_NFE INT ,
		   SERIE VARCHAR(100) ,
		   NR_DOC INT ,
		   CHAVE_NFE VARCHAR(150) ,
		   DT_EMI_NF DATETIME NULL,
		   DT_ENT_SAI DATETIME NULL,
		   VLR_NF MONEY ,
		   IND_PAGTO INT ,
		   VLR_DESC MONEY ,
		   VLR_ABAT INT ,
		   VLR_MERC MONEY NULL,
		   TP_FRETE INT ,
		   VLR_FRETE MONEY ,
		   VLR_SEG INT ,
		   VLR_OUTRAS_DESP_CAB MONEY ,
		   VLR_BASE_ICMS_CAB MONEY NULL,
		   VLR_ICMS_CAB MONEY NULL,
		   VLR_BASE_ICMS_SUBS_CAB MONEY ,
		   VLR_ICMS_SUBS_CAB MONEY ,
		   VLR_IPI_CAB MONEY ,
		   VLR_ISENTAS_CAB MONEY ,
		   CGC_CPF VARCHAR(30) ,
		   STS_NF INT ,
		   VLR_SERV_NT MONEY ,
		   VLR_BASE_ISSQN_CAB INT ,
		   VLR_ISSQN_CAB INT ,
		   VLR_BASE_IRRF_CAB INT ,
		   VLR_IRRF_CAB INT ,
		   CD_TRANSP INT ,
		   QT_VOL MONEY ,
		   PESO_BRT MONEY ,
		   PESO_LIQ MONEY ,
		   POSSUI_DUPL INT ,
		   TP_MOV INT ,
		   TP_MOV_OP_TRANSA INT ,
		   DEST_ORIG INT ,
		   TIPO_PART VARCHAR(30) ,
		   NUM_ITEM INT ,
		   COD_ITEM INT ,
		   TIPO_ITEM INT ,
		   DS_PROD VARCHAR(150) NULL,
		   QT_IT MONEY ,
		   VLR_IT MONEY ,
		   VLR_ITEM MONEY NULL,
		   CST_ICMS VARCHAR(80) ,
		   TRIB_FC_ELETRONICO VARCHAR(100) ,
		   CFOP VARCHAR(100) NULL,
		   VLR_BASE_ICMS MONEY ,
		   ALIQ_ICMS MONEY ,
		   VLR_ICMS_IT MONEY ,
		   VLR_BASE_SUBS MONEY ,
		   VLR_ICMS_SUBS MONEY ,
		   VLR_IPI_IT MONEY ,
		   PERC_IPI MONEY ,
		   VLR_ISENTO_IT MONEY ,
		   CST_PIS INT ,
		   CST_COFINS INT ,
		   VLR_BASE_PIS MONEY ,
		   PERC_ALIQ_PIS MONEY ,
		   VLR_PIS MONEY ,
		   VLR_BASE_COFINS MONEY ,
		   PERC_ALIQ_COFINS MONEY ,
		   VLR_COFINS MONEY ,
		   VLR_OUTRAS_DESPESAS_IT MONEY NULL,
		   VLR_BASE_ISSQN INT ,
		   VLR_ISSQN INT ,
		   ALIQ_ISSQN INT ,
		   COD_PART INT NULL,
		   COD_IMP_ALMOX INT ,
		   LISTA_PROD INT NULL,
		   SUBS_TRIB INT ,
		   SUBS_TRIB_ANT INT ,
		   CD_NT_OP INT ,
		   ICMS INT ,
		   ICMS_RD INT ,
		   FLAG_OPERADOR_LOG INT ,
		   QTDE_PROD MONEY ,
		   NR_LOTE NVARCHAR(100) ,
		   DT_VALID DATETIME ,
		   DT_FABR DATETIME ,
		   VLR_TABELA MONEY NULL,
		   PROD_MEDICAM INT ,
		   TIPO_MEDIC INT ,
		   NOME_PART VARCHAR(150) ,
		   ENDERECO VARCHAR(150) ,
		   BAIRRO VARCHAR(150) ,
		   NUMERO VARCHAR(150) ,
		   INSC_EST VARCHAR(50) ,
		   UF VARCHAR(10) ,
		   TEL VARCHAR(50) ,
		   CD_PAIS INT ,
		   COD_IBGE VARCHAR(150) ,
		   CEP VARCHAR(20) ,
		   TP_PROD INT ,
		   COD_BARRA VARCHAR(50) ,
		   COD_NCM VARCHAR(50) ,
		   VLR_DESC_IT MONEY ,
		   PIS_NF MONEY ,
		   COFINS_NF MONEY ,
		   DS_NT_OP VARCHAR(300) NULL,
		   CD_MOV_OP INT ,
		   FLAG_NAO_GERAR_ARQ_SPED INT   NULL,
		   CD_TRIB INT ,
		   CANCEL_FORA_PRAZO INT ,
		   PROTOCOLO_CANCEL VARCHAR(50)   NULL,
		   POSSUI_DARE INT ,
		   NUM_DARE VARCHAR(10)   NULL,
		   VALOR_DARE VARCHAR(10)   NULL,
		   DT_VENCTO_DARE VARCHAR(10)   NULL,
		   DT_RECOLHIMENTO_DARE VARCHAR(10)   NULL,
		   FLAG_MOV_OP_NFE_CPL INT ,
		   NOTA_DENEGADA INT ,
		   VLR_FRETE_CABE_RATEIO FLOAT NULL,
		   CD_NF_SAI INT ,
		   VLR_FECOP MONEY NULL,
		   NR_CEST VARCHAR(20) ,
		   COD_IBGE_MUNICIPIO_DESTINATARIO VARCHAR(50) ,
		   END_DESTINATARIO VARCHAR(100) ,
		   BAIRRO_DESTINATARIO VARCHAR(50) ,
		   CEP_DESTINATARIO VARCHAR(50) ,
		   CIDADE_DESTINATARIO VARCHAR(50) ,
		   CNPJ_DESTINATARIO VARCHAR(50) ,
		   INSC_ESTADUAL_DESTINATARIO VARCHAR(50) ,
		   RZ_DESTINATARIO VARCHAR(60) ,
		   UF_DESTINATARIO VARCHAR(50) ,
		   CD_CID_DESTINATARIO INT ,
		   ALIQ_ICMS_INTERNO MONEY ,
		   VLR_ICMS_DESONERADO MONEY NULL,
		   PART_FLAG_MICRO_EMPRESA INT ,
		   BASE_ICMS_SIMPLES MONEY NULL,
		   ALIQ_SIMPLES MONEY NULL,
		   VLR_ICMS_SIMPLES MONEY NULL,
		   VLR_CUSTO_MD MONEY NULL,
		   VLR_ICMS_DESONERADO_IT MONEY NULL,
		   VLR_FECOP_ST MONEY NULL,
		   VLR_FECOP_ST_RET MONEY NULL,
		   VLR_FECOP_IT MONEY NULL,
		   VLR_FECOP_ST_IT MONEY NULL,
		   VLR_FECOP_ST_RET_IT MONEY NULL,
		   NR_SERV VARCHAR(10), 
		   FLAG_VLR_ICMS_DESONERADO_DESCONTO INT  NULL,
           VLR_ICMS_RET_IT MONEY NULL
		   
	   )
 
-------------------------------------------------------------------------------------------------
CREATE TABLE #FILIAIS (CD_EMP INT ,CD_FILIAL INT,FLAG_OPERADOR_LOG INT )
			 INSERT INTO #FILIAIS
				   SELECT CD_EMP,
						CD_FILIAL,
						FLAG_OPERADOR_LOG
				   FROM PRC_FILIAL
				   WHERE CD_FILIAL IN
			 (
				SELECT ID
				FROM UFD_PRM_IN_STRING(@CD_FILIAL)
			 );
-------------------------------------------------------------------------------------------------

INSERT INTO #V_SPED_NF_ENT 
	   SELECT EST_NF_ENT.CD_EMP,
			EST_NF_ENT.CD_FILIAL,
			EST_NF_ENT.CD_NF AS CD_DOC,
			0 AS IND_OPER,
			(CASE
				WHEN EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT > 0
				THEN 0
				ELSE 1
			 END) AS IND_EMIT,
			EST_NF_ENT.CD_FORN AS CD_ORIG,
			LEFT(EST_NF_SERIE.MODELO,2),
			EST_NF_SERIE.TP_SR_NFE,
			EST_NF_SERIE.SERIE,
			EST_NF_ENT.NR_NF AS NR_DOC,
			ISNULL(V_EST_NF_ENT_NFE_SPED.NR_AUTORIZADOR, '') AS CHAVE_NFE,
			EST_NF_ENT.DT_EMI_NF,
			EST_NF_ENT.DT_ENT AS DT_ENT_SAI,
			EST_NF_ENT.VLR_NF,
			PGTO_VISTA_PRAZO AS IND_PAGTO,
			EST_NF_ENT.VLR_DESC,
			0 AS VLR_ABAT,
			CASE
			    WHEN ISNULL(EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0
			    THEN EST_NF_ENT.VLR_TOT_PROD
			    ELSE EST_NF_ENT.VLR_TOT_PROD - EST_NF_ENT.VLR_DESC
			END AS VLR_MERC,
			1 AS TP_FRETE,
			VLR_FRETE,
			0 AS VLR_SEG,
			EST_NF_ENT.VLR_OUTROS AS VLR_OUTRAS_DESP_CAB,
			V_APURA_ICMS.VLR_BASE_ICMS_CAB,
			V_APURA_ICMS.VLR_ICMS_CAB,
			EST_NF_ENT.VLR_BASE_ICMS_SUBS AS VLR_BASE_ICMS_SUBS_CAB,
			EST_NF_ENT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_CAB,
			EST_NF_ENT.VLR_IPI AS VLR_IPI_CAB,
			EST_NF_ENT.VRL_ISENTAS AS VLR_ISENTAS_CAB,
			'' AS CGC_CPF,
			EST_NF_ENT.STS_NF,
			EST_NF_ENT.VLR_OUTROS AS VLR_SERV_NT,
			0 AS VLR_BASE_ISSQN_CAB,
			0 VLR_ISSQN_CAB,
			0 AS VLR_BASE_IRRF_CAB,
			0 AS VLR_IRRF_CAB,
			0 AS CD_TRANSP,
			QT_VOL,
			PESO_BRT,
			PESO_LIQ,
			ISNULL(
	   (
		  SELECT TOP 1 CD_EMP
		  FROM PG_CRED_EST_NF_ENT
		  WHERE EST_NF_ENT.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP
			   AND EST_NF_ENT.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL
			   AND EST_NF_ENT.CD_NF = PG_CRED_EST_NF_ENT.CD_NF
	   ), 0) AS POSSUI_DUPL,
			GLB_MOV_OP.TP_MOV,
			GLB_MOV_OP.TP_MOV_OP_TRANSA,
			GLB_MOV_OP.DEST_ORIG,
			CASE
			    WHEN GLB_MOV_OP.DEST_ORIG = 0
			    THEN 'CLI'
			    WHEN GLB_MOV_OP.DEST_ORIG = 1
			    THEN 'FOR'
			    ELSE 'FIL'
			END AS TIPO_PART,
			EST_NF_ENT_IT.SEQ_ITEM AS NUM_ITEM,
			EST_NF_ENT_IT.CD_PROD AS COD_ITEM,
			EST_PROD_CPL.TP_PROD AS TIPO_ITEM,
			EST_PROD.DS_PROD, -- 
			EST_NF_ENT_IT.QT_IT,
			EST_NF_ENT_IT.VLR_IT,
			CASE
			    WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0
			    THEN DBO.EST_NF_ENT_IT.VLR_TOT_IT
			    ELSE DBO.EST_NF_ENT_IT.VLR_TOT_IT - EST_NF_ENT_IT.VLR_DESC
			END AS VLR_ITEM,
			EST_TRIB.CD_TRIB_FC AS CST_ICMS,
			EST_TRIB.TRIB_FC_ELETRONICO,
			GLB_NT_OP.CD_NT_OP_FC AS CFOP,
			CASE
			    WHEN EST_TRIB.ICMS > 0
			    THEN EST_NF_ENT_IT.VLR_BASE_ICMS
			    ELSE 0
			END VLR_BASE_ICMS,
			CASE
			    WHEN EST_TRIB.ICMS > 0  OR ( GLB_MOV_OP.TP_MOV IN ( 27,21) )
			    THEN EST_NF_ENT_IT.ALIQ_ICMS
			    ELSE 0
			END ALIQ_ICMS,
			CASE
			    WHEN EST_TRIB.ICMS > 0
				    OR GLB_MOV_OP.TP_MOV IN(58)
			    THEN EST_NF_ENT_IT.VLR_ICMS_IT
			    ELSE 0
			END VLR_ICMS_IT,
			EST_NF_ENT_IT.VLR_BASE_SUBS AS VLR_BASE_SUBS,
			EST_NF_ENT_IT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS,
			EST_NF_ENT_IT.VLR_IPI AS VLR_IPI_IT,
			EST_NF_ENT_IT.PERC_IPI,
			EST_NF_ENT_IT.VLR_ISENTO AS VLR_ISENTO_IT,
			ISNULL(EST_NF_ENT_IT.CST_PIS, 0) CST_PIS,
			ISNULL(EST_NF_ENT_IT.CST_COFINS, 0) CST_COFINS,
			ISNULL(EST_NF_ENT_IT.VLR_BASE_PIS, 0) VLR_BASE_PIS,
			ISNULL(EST_NF_ENT_IT.PERC_ALIQ_PIS, 0) PERC_ALIQ_PIS,
			ISNULL(EST_NF_ENT_IT.VLR_PIS, 0) VLR_PIS,
			ISNULL(EST_NF_ENT_IT.VLR_BASE_COFINS, 0) VLR_BASE_COFINS,
			ISNULL(EST_NF_ENT_IT.PERC_ALIQ_COFINS, 0) PERC_ALIQ_COFINS,
			ISNULL(EST_NF_ENT_IT.VLR_COFINS, 0) VLR_COFINS,
			EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS AS VLR_OUTRAS_DESPESAS_IT,
			0 AS VLR_BASE_ISSQN,
			0 AS VLR_ISSQN,
			0 AS ALIQ_ISSQN,
			EST_NF_ENT.CD_FORN AS COD_PART,
			1 AS COD_IMP_ALMOX,
			EST_NF_ENT_IT.LISTA_PROD,
			EST_TRIB.SUBS_TRIB,
			EST_TRIB.SUBS_TRIB_ANT,
			EST_NF_ENT_IT.CD_NT_OP,
			EST_TRIB.ICMS,
			EST_TRIB.ICMS_RD,
			FLAG_OPERADOR_LOG,
			ISNULL(
	   (
		  SELECT SUM(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD) QTDE_PROD
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS QTDE_PROD,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.NR_LOTE
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
		  ORDER BY EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS NR_LOTE,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.DT_VALID
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS DT_VALID,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.DT_FABR
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS DT_FABR,
			EST_PROD_PRECO.VLR_TABELA,
			CASE
			    WHEN CTR_PMC = 1
			    THEN 1
			    ELSE 0
			END AS PROD_MEDICAM,
			(CASE
				WHEN DS_SIGLA_LINHA = 'S'
				THEN 0   --' SIGLAS: E - ETICO,   S - SIMILAR, G - GENERICO |0- SIMILAR; 1- GEN?RICO; 2- ?TICO;
				WHEN DS_SIGLA_LINHA = 'G'
				THEN 1
				WHEN DS_SIGLA_LINHA = 'E'
				THEN 2
				ELSE 0
			 END) TIPO_MEDIC,
			'' AS NOME_PART,
			'' AS ENDERECO,
			'' AS BAIRRO,
			'' AS NUMERO,
			'' AS INSC_EST,
			'' AS UF,
			'' AS TEL,
			01058 AS CD_PAIS,
			ISNULL(GLB_MUNICIPIO.COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE, -- SELECT TOP 2 CEP,* FROM V_EST_NF_ENT
			'' AS CEP,
			EST_PROD_CPL.TP_PROD,
			ISNULL(
	   (
		  SELECT TOP (1) CD_BARRA
		  FROM EST_PROD_CD_BARRA
		  WHERE CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND CD_PROD = EST_NF_ENT_IT.CD_PROD
		  ORDER BY CD_BARRA
	   ), '') AS COD_BARRA,
			EST_PROD.NR_NCM AS COD_NCM,
			EST_NF_ENT_IT.VLR_DESC AS VLR_DESC_IT,
			ISNULL(V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.PIS_NF, 0) PIS_NF,
			ISNULL(V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.COFINS_NF, 0) COFINS_NF,
			GLB_NT_OP.DS_NT_OP,
			GLB_MOV_OP.CD_MOV_OP,
			ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) AS FLAG_NAO_GERAR_ARQ_SPED,
			EST_TRIB.CD_TRIB,
			ISNULL(EST_NF_ENT_CANCEL.CANCEL_FORA_PRAZO, 0) CANCEL_FORA_PRAZO,
			ISNULL(EST_NF_ENT_NFE_CANCEL.NR_PROTOCOLO, '') AS PROTOCOLO_CANCEL,
			0 AS POSSUI_DARE,
			'' AS NUM_DARE,
			'' AS VALOR_DARE,
			'' AS DT_VENCTO_DARE,
			'' AS DT_RECOLHIMENTO_DARE,
			FLAG_MOV_OP_NFE_CPL, -- SELECT TOP 2 VLR_FRETE_CABE_RATEIO, * FROM V_EST_NF_ENT WHERE CD_FILIAL = 1030 AND NR_NF = 13341
			ISNULL(EST_NF_ENT_DENEGADA.CD_EMP, 0) AS NOTA_DENEGADA,
			CASE
			    WHEN EST_NF_ENT.VLR_FRETE = 0
			    THEN 0
			    ELSE CASE
					   WHEN CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE) > 0
					   THEN ROUND((ROUND((CONVERT(FLOAT, EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE)), 9) * (ROUND(((EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT) - EST_NF_ENT_IT.VLR_DESC), 2) + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_ICMS_SUBS)), 2)
					   ELSE 0
				    END
			END AS VLR_FRETE_CABE_RATEIO,
			ISNULL(EST_NF_SAI_NF_ENT.CD_NF_SAI, 0) CD_NF_SAI,
			ISNULL(EST_NF_ENT.VLR_FECOP,0 ) AS VLR_FECOP,
			ISNULL(NR_CEST, '') AS NR_CEST,
			ISNULL(COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE_MUNICIPIO_DESTINATARIO,
			ISNULL(EST_NF_ENT.END_DESTINATARIO, '') AS END_DESTINATARIO,
			ISNULL(EST_NF_ENT.BAIRRO_DESTINATARIO, '') AS BAIRRO_DESTINATARIO,
			ISNULL(EST_NF_ENT.CEP_DESTINATARIO, '') AS CEP_DESTINATARIO,
			ISNULL(EST_NF_ENT.CIDADE_DESTINATARIO, '') AS CIDADE_DESTINATARIO,
			ISNULL(EST_NF_ENT.CNPJ_DESTINATARIO, '') AS CNPJ_DESTINATARIO,
			ISNULL(EST_NF_ENT.INSC_ESTADUAL_DESTINATARIO, '') INSC_ESTADUAL_DESTINATARIO,
			ISNULL(LEFT(EST_NF_ENT.RZ_DESTINATARIO,60), '') AS RZ_DESTINATARIO,
			ISNULL(EST_NF_ENT.UF_DESTINATARIO, '') AS UF_DESTINATARIO,
			ISNULL(EST_NF_ENT.CD_CID_DESTINATARIO, '') CD_CID_DESTINATARIO,
					 
			CASE
			    WHEN GLB_MOV_OP.TP_MOV IN ( 27,21)  --compra de uso e consumo e ativo imobilizado 
			    THEN EST_NF_ENT_IT.ALIQ_ICMS
			    ELSE ISNULL(EST_NF_ENT_IT.ALIQ_ICMS_INTERNO, 0) 
			END ALIQ_ICMS_INTERNO,
			--			ISNULL(EST_NF_ENT_IT.ALIQ_ICMS_INTERNO, 0) AS ALIQ_ICMS_INTERNO,
			V_APURA_ICMS.VLR_ICMS_DESONERADO,
			0 AS PART_FLAG_MICRO_EMPRESA,
			V_APURA_ICMS.BASE_ICMS_SIMPLES,
			V_APURA_ICMS.ALIQ_SIMPLES,
			V_APURA_ICMS.VLR_ICMS_SIMPLES,
			ISNULL(EST_PROD_CPL.VLR_CUSTO_MD,0 )VLR_CUSTO_MD,
			ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) VLR_ICMS_DESONERADO_IT,
			ISNULL(EST_NF_ENT.VLR_FECOP_ST,0)VLR_FECOP_ST,
			ISNULL(EST_NF_ENT.VLR_FECOP_ST_RET,0 )VLR_FECOP_ST_RET,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP,0 )VLR_FECOP_IT,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP_ST,0 )VLR_FECOP_ST_IT,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP_RET,0 )VLR_FECOP_ST_RET_IT,
			ISNULL(EST_PROD.NR_SERV,'') AS NR_SERV,
			ISNULL(FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) AS FLAG_VLR_ICMS_DESONERADO_DESCONTO,
			ISNULL(VLR_ICMS_RET,0) AS VLR_ICMS_RET_IT
	 
	   FROM DBO.EST_NF_ENT   
		   INNER JOIN #FILIAIS FL ON DBO.EST_NF_ENT.CD_EMP = FL.CD_EMP
								 AND DBO.EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL
		   INNER JOIN DBO.EST_NF_ENT_IT ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
									AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
									AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
									AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT

		  INNER JOIN DBO.EST_TRIB   ON DBO.EST_NF_ENT_IT.CD_TRIB = EST_TRIB.CD_TRIB
		  INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_ENT_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP

		   INNER JOIN DBO.EST_PROD ON DBO.EST_PROD.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
								AND DBO.EST_PROD.CD_PROD = DBO.EST_NF_ENT_IT.CD_PROD
		   
		   INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
		   INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
								    AND DBO.EST_NF_ENT.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE
		   LEFT JOIN V_APURA_ICMS ON EST_NF_ENT.CD_EMP = V_APURA_ICMS.CD_EMP
								AND EST_NF_ENT.CD_FILIAL = V_APURA_ICMS.CD_FILIAL
								AND EST_NF_ENT.CD_NF = V_APURA_ICMS.CD_NF
								AND V_APURA_ICMS.TIPO = 0
		   INNER JOIN EST_PROD_CPL ON EST_NF_ENT_IT.CD_EMP = EST_PROD_CPL.CD_EMP
								AND EST_NF_ENT_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
								AND EST_NF_ENT_IT.CD_PROD = EST_PROD_CPL.CD_PROD
		   INNER JOIN DBO.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON EST_PROD.CD_EMP = ARV.CD_EMP
													    AND EST_PROD.CD_PROD = ARV.CD_PROD
		   INNER JOIN DBO.EST_ARV_MERC_LINHA AS LINHA ON ARV.CD_EMP = LINHA.CD_EMP
											    AND ARV.CD_ARV_MERC_LINHA = LINHA.CD_ARV_MERC_LINHA
		   LEFT JOIN V_EST_NF_ENT_IMPOSTOS_PIS_COFINS ON V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_EMP = EST_NF_ENT.CD_EMP
				  AND V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_FILIAL = EST_NF_ENT.CD_FILIAL
				  AND V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_NF = EST_NF_ENT.CD_NF
		   LEFT JOIN EST_PROD_PRECO ON EST_PROD_PRECO.CD_EMP = EST_NF_ENT_IT.CD_EMP
								 AND EST_PROD_PRECO.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
								 AND EST_PROD_PRECO.CD_PROD = EST_NF_ENT_IT.CD_PROD
		   LEFT JOIN EST_NF_ENT_DAR_IT ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP
									AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL
									AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DAR_IT.CD_NF
									AND EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_DAR_IT.CD_PROD

		   LEFT JOIN EST_NF_ENT_DAR ON EST_NF_ENT_DAR.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP
								  AND EST_NF_ENT_DAR.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL
								  AND EST_NF_ENT_DAR.CD_NF = EST_NF_ENT_DAR_IT.CD_NF
		   LEFT JOIN EST_NF_ENT_EF_NF_CTR_NF ON EST_NF_ENT_EF_NF_CTR_NF.CD_EMP = EST_NF_ENT.CD_EMP
										AND EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL = EST_NF_ENT.CD_FILIAL
										AND EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT = EST_NF_ENT.CD_NF
		   LEFT JOIN V_EST_NF_ENT_NFE_SPED ON V_EST_NF_ENT_NFE_SPED.CD_EMP = EST_NF_ENT.CD_EMP
									   AND V_EST_NF_ENT_NFE_SPED.CD_FILIAL = EST_NF_ENT.CD_FILIAL
									   AND V_EST_NF_ENT_NFE_SPED.CD_NF = EST_NF_ENT.CD_NF
		   INNER JOIN GLB_USU ON EST_NF_ENT.CD_USU = GLB_USU.CD_USU
		   LEFT JOIN GLB_CID ON EST_NF_ENT.CD_CID_DESTINATARIO = GLB_CID.CD_CID
		   LEFT OUTER JOIN GLB_CID_GLB_MUNICIPIO ON GLB_CID.CD_CID = GLB_CID_GLB_MUNICIPIO.CD_CID
		   LEFT OUTER JOIN GLB_MUNICIPIO ON GLB_CID_GLB_MUNICIPIO.CD_MUNICIPIO = GLB_MUNICIPIO.CD_MUNICIPIO
		   LEFT JOIN EST_NF_ENT_CANCEL ON EST_NF_ENT_CANCEL.CD_EMP = EST_NF_ENT.CD_EMP
								    AND EST_NF_ENT_CANCEL.CD_FILIAL = EST_NF_ENT.CD_FILIAL
								    AND EST_NF_ENT_CANCEL.CD_NF = EST_NF_ENT.CD_NF
		   LEFT JOIN EST_NF_ENT_NFE_CANCEL ON EST_NF_ENT_CANCEL.CD_EMP = EST_NF_ENT_NFE_CANCEL.CD_EMP
									   AND EST_NF_ENT_CANCEL.CD_FILIAL = EST_NF_ENT_NFE_CANCEL.CD_FILIAL
									   AND EST_NF_ENT_CANCEL.CD_NF = EST_NF_ENT_NFE_CANCEL.CD_NF
		   LEFT JOIN EST_NF_ENT_DENEGADA ON EST_NF_ENT.CD_EMP = EST_NF_ENT_DENEGADA.CD_EMP
									 AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DENEGADA.CD_FILIAL
									 AND EST_NF_ENT.CD_NF = EST_NF_ENT_DENEGADA.CD_NF
		   LEFT JOIN EST_NF_SAI_NF_ENT ON EST_NF_ENT.CD_EMP = EST_NF_SAI_NF_ENT.CD_EMP
								    AND EST_NF_ENT.CD_FILIAL = EST_NF_SAI_NF_ENT.CD_FILIAL
								    AND EST_NF_ENT.CD_NF = EST_NF_SAI_NF_ENT.CD_NF_ENT 
	   WHERE  
			 EST_NF_ENT.CD_EMP = 1 
			 AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
			 AND EST_NF_ENT_DAR_IT.CD_EMP IS NULL
	 
    UNION ALL
	   SELECT EST_NF_ENT.CD_EMP,
			EST_NF_ENT.CD_FILIAL,
			EST_NF_ENT.CD_NF AS CD_DOC,
			0 AS IND_OPER,
			(CASE
				WHEN EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT > 0
				THEN 0
				ELSE 1
			 END) AS IND_EMIT,
			EST_NF_ENT.CD_FORN AS CD_ORIG,
			LEFT(EST_NF_SERIE.MODELO,2),
			EST_NF_SERIE.TP_SR_NFE,
			EST_NF_SERIE.SERIE,
			EST_NF_ENT.NR_NF AS NR_DOC,
			ISNULL(V_EST_NF_ENT_NFE_SPED.NR_AUTORIZADOR, '') AS CHAVE_NFE,
			EST_NF_ENT.DT_EMI_NF,
			EST_NF_ENT.DT_ENT AS DT_ENT_SAI,
			EST_NF_ENT.VLR_NF,
			PGTO_VISTA_PRAZO AS IND_PAGTO,
			EST_NF_ENT.VLR_DESC,
			0 AS VLR_ABAT,
			CASE
			    WHEN ISNULL(EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0
			    THEN EST_NF_ENT.VLR_TOT_PROD
			    ELSE EST_NF_ENT.VLR_TOT_PROD - EST_NF_ENT.VLR_DESC
			END AS VLR_MERC,
			1 AS TP_FRETE,
			VLR_FRETE,
			0 AS VLR_SEG,
			EST_NF_ENT.VLR_OUTROS AS VLR_OUTRAS_DESP_CAB,
			V_APURA_ICMS.VLR_BASE_ICMS_CAB,
			V_APURA_ICMS.VLR_ICMS_CAB,
			EST_NF_ENT.VLR_BASE_ICMS_SUBS AS VLR_BASE_ICMS_SUBS_CAB,
			EST_NF_ENT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_CAB,
			EST_NF_ENT.VLR_IPI AS VLR_IPI_CAB,
			EST_NF_ENT.VRL_ISENTAS AS VLR_ISENTAS_CAB,
			'' AS CGC_CPF,
			EST_NF_ENT.STS_NF,
			EST_NF_ENT.VLR_OUTROS AS VLR_SERV_NT,
			0 AS VLR_BASE_ISSQN_CAB,
			0 VLR_ISSQN_CAB,
			0 AS VLR_BASE_IRRF_CAB,
			0 AS VLR_IRRF_CAB,
			0 AS CD_TRANSP,
			QT_VOL,
			PESO_BRT,
			PESO_LIQ,
			ISNULL(
	   (
		  SELECT TOP 1 CD_EMP
		  FROM PG_CRED_EST_NF_ENT
		  WHERE EST_NF_ENT.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP
			   AND EST_NF_ENT.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL
			   AND EST_NF_ENT.CD_NF = PG_CRED_EST_NF_ENT.CD_NF
	   ), 0) AS POSSUI_DUPL,
			GLB_MOV_OP.TP_MOV,
			GLB_MOV_OP.TP_MOV_OP_TRANSA,
			GLB_MOV_OP.DEST_ORIG,
			CASE
			    WHEN GLB_MOV_OP.DEST_ORIG = 0
			    THEN 'CLI'
			    WHEN GLB_MOV_OP.DEST_ORIG = 1
			    THEN 'FOR'
			    ELSE 'FIL'
			END AS TIPO_PART,
			EST_NF_ENT_IT.SEQ_ITEM AS NUM_ITEM,
			EST_NF_ENT_IT.CD_PROD AS COD_ITEM,
			EST_PROD_CPL.TP_PROD AS TIPO_ITEM,
			EST_PROD.DS_PROD, -- 
			EST_NF_ENT_IT.QT_IT,
			EST_NF_ENT_IT.VLR_IT,
			CASE
			    WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0
			    THEN DBO.EST_NF_ENT_IT.VLR_TOT_IT
			    ELSE DBO.EST_NF_ENT_IT.VLR_TOT_IT - EST_NF_ENT_IT.VLR_DESC
			END AS VLR_ITEM,
			TRIB_DARE.CD_TRIB_FC AS CST_ICMS,
			TRIB_DARE.TRIB_FC_ELETRONICO,
			GLB_NT_OP.CD_NT_OP_FC AS CFOP,
			CASE
			    WHEN TRIB_DARE.ICMS > 0
			    THEN EST_NF_ENT_DAR_IT.VLR_BASE_ICMS
			    ELSE 0
			END AS VLR_BASE_ICMS,
			CASE
			    WHEN TRIB_DARE.ICMS > 0
			    THEN EST_NF_ENT_DAR_IT.PERC_ICMS
			    ELSE 0
			END ALIQ_ICMS,
			CASE
			    WHEN TRIB_DARE.ICMS > 0
			    THEN EST_NF_ENT_DAR_IT.VLR_ICMS
			    ELSE 0
			END AS VLR_ICMS_IT,
			EST_NF_ENT_DAR_IT.VLR_BASE_SUBS AS VLR_BASE_SUBS,
			EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS,
			EST_NF_ENT_IT.VLR_IPI AS VLR_IPI_IT,
			EST_NF_ENT_IT.PERC_IPI,
			EST_NF_ENT_IT.VLR_ISENTO AS VLR_ISENTO_IT,
			ISNULL(EST_NF_ENT_IT.CST_PIS, 0) CST_PIS,
			ISNULL(EST_NF_ENT_IT.CST_COFINS, 0) CST_COFINS,
			ISNULL(EST_NF_ENT_IT.VLR_BASE_PIS, 0) VLR_BASE_PIS,
			ISNULL(EST_NF_ENT_IT.PERC_ALIQ_PIS, 0) PERC_ALIQ_PIS,
			ISNULL(EST_NF_ENT_IT.VLR_PIS, 0) VLR_PIS,
			ISNULL(EST_NF_ENT_IT.VLR_BASE_COFINS, 0) VLR_BASE_COFINS,
			ISNULL(EST_NF_ENT_IT.PERC_ALIQ_COFINS, 0) PERC_ALIQ_COFINS,
			ISNULL(EST_NF_ENT_IT.VLR_COFINS, 0) VLR_COFINS,
			EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS AS VLR_OUTRAS_DESPESAS_IT,
			0 AS VLR_BASE_ISSQN,
			0 AS VLR_ISSQN,
			0 AS ALIQ_ISSQN,
			EST_NF_ENT.CD_FORN AS COD_PART,
			1 AS COD_IMP_ALMOX,
			EST_NF_ENT_IT.LISTA_PROD,
			TRIB_DARE.SUBS_TRIB,
			TRIB_DARE.SUBS_TRIB_ANT,
			EST_NF_ENT_IT.CD_NT_OP,
			TRIB_DARE.ICMS,
			TRIB_DARE.ICMS_RD,
			FLAG_OPERADOR_LOG,
			ISNULL(
	   (
		  SELECT SUM(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD) QTDE_PROD
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS QTDE_PROD,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.NR_LOTE
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
		  ORDER BY EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS NR_LOTE,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.DT_VALID
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS DT_VALID,
			ISNULL(
	   (
		  SELECT TOP (1) EST_PROD_CPL_LOTE.DT_FABR
		  FROM EST_NF_ENT_IT_EST_PROD_CPL_LOTE,
			  EST_PROD_CPL_LOTE
		  WHERE EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF = EST_NF_ENT_IT.CD_NF
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD = EST_NF_ENT_IT.CD_PROD
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL
			   AND EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	   ), 0) AS DT_FABR,
			EST_PROD_PRECO.VLR_TABELA,
			CASE
			    WHEN CTR_PMC = 1
			    THEN 1
			    ELSE 0
			END AS PROD_MEDICAM,
			(CASE
				WHEN DS_SIGLA_LINHA = 'S'
				THEN 0   --' SIGLAS: E - ETICO,   S - SIMILAR, G - GENERICO |0- SIMILAR; 1- GEN?RICO; 2- ?TICO;
				WHEN DS_SIGLA_LINHA = 'G'
				THEN 1
				WHEN DS_SIGLA_LINHA = 'E'
				THEN 2
				ELSE 0
			 END) TIPO_MEDIC,
			'' AS NOME_PART,
			'' AS ENDERECO,
			'' AS BAIRRO,
			'' AS NUMERO,
			'' AS INSC_EST,
			'' AS UF,
			'' AS TEL,
			01058 AS CD_PAIS,
			ISNULL(GLB_MUNICIPIO.COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE, -- SELECT TOP 2 CEP,* FROM V_EST_NF_ENT
			'' AS CEP,
			EST_PROD_CPL.TP_PROD,
			ISNULL(
	   (
		  SELECT TOP (1) CD_BARRA
		  FROM EST_PROD_CD_BARRA
		  WHERE CD_EMP = EST_NF_ENT_IT.CD_EMP
			   AND CD_PROD = EST_NF_ENT_IT.CD_PROD
		  ORDER BY CD_BARRA
	   ), '') AS COD_BARRA,
			EST_PROD.NR_NCM AS COD_NCM,
			EST_NF_ENT_IT.VLR_DESC AS VLR_DESC_IT,
			ISNULL(V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.PIS_NF, 0) PIS_NF,
			ISNULL(V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.COFINS_NF, 0) COFINS_NF,
			GLB_NT_OP.DS_NT_OP,
			GLB_MOV_OP.CD_MOV_OP,
			ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) AS FLAG_NAO_GERAR_ARQ_SPED,
			EST_NF_ENT_DAR_IT.CD_TRIB,
			ISNULL(EST_NF_ENT_CANCEL.CANCEL_FORA_PRAZO, 0) CANCEL_FORA_PRAZO,
			ISNULL(EST_NF_ENT_NFE_CANCEL.NR_PROTOCOLO, '') AS PROTOCOLO_CANCEL,
			1 AS POSSUI_DARE,
			EST_NF_ENT_DAR.NR_DAR AS NUM_DARE,
			EST_NF_ENT_DAR.VLR_DAR AS VALOR_DARE,
			EST_NF_ENT_DAR.DT_VENCTO AS DT_VENCTO_DARE,
			EST_NF_ENT_DAR.DT_RECOLHIMENTO AS DT_RECOLHIMENTO_DARE,
			FLAG_MOV_OP_NFE_CPL, -- SELECT TOP 2 VLR_FRETE_CABE_RATEIO, * FROM V_EST_NF_ENT WHERE CD_FILIAL = 1030 AND NR_NF = 13341
			ISNULL(EST_NF_ENT_DENEGADA.CD_EMP, 0) AS NOTA_DENEGADA,
			CASE
			    WHEN EST_NF_ENT.VLR_FRETE = 0
			    THEN 0
			    ELSE CASE
					   WHEN CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE) > 0
					   THEN ROUND((ROUND((CONVERT(FLOAT, EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE)), 9) * (ROUND(((EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT) - EST_NF_ENT_IT.VLR_DESC), 2) + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_ICMS_SUBS)), 2)
					   ELSE 0
				    END
			END AS VLR_FRETE_CABE_RATEIO,
			ISNULL(EST_NF_SAI_NF_ENT.CD_NF_SAI, 0) CD_NF_SAI,
			ISNULL(EST_NF_ENT.VLR_FECOP,0)VLR_FECOP,
			ISNULL(NR_CEST, '') AS NR_CEST,
			ISNULL(COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE_MUNICIPIO_DESTINATARIO,
			ISNULL(EST_NF_ENT.END_DESTINATARIO, '') AS END_DESTINATARIO,
			ISNULL(EST_NF_ENT.BAIRRO_DESTINATARIO, '') AS BAIRRO_DESTINATARIO,
			ISNULL(EST_NF_ENT.CEP_DESTINATARIO, '') AS CEP_DESTINATARIO,
			ISNULL(EST_NF_ENT.CIDADE_DESTINATARIO, '') AS CIDADE_DESTINATARIO,
			ISNULL(EST_NF_ENT.CNPJ_DESTINATARIO, '') AS CNPJ_DESTINATARIO,
			ISNULL(EST_NF_ENT.INSC_ESTADUAL_DESTINATARIO, '') INSC_ESTADUAL_DESTINATARIO,
			ISNULL(EST_NF_ENT.RZ_DESTINATARIO, '') AS RZ_DESTINATARIO,
			ISNULL(EST_NF_ENT.UF_DESTINATARIO, '') AS UF_DESTINATARIO,
			ISNULL(EST_NF_ENT.CD_CID_DESTINATARIO, '') CD_CID_DESTINATARIO,
			ISNULL(EST_NF_ENT_IT.ALIQ_ICMS_INTERNO, 0) AS ALIQ_ICMS_INTERNO,
			V_APURA_ICMS.VLR_ICMS_DESONERADO,
			0 AS PART_FLAG_MICRO_EMPRESA,
			V_APURA_ICMS.BASE_ICMS_SIMPLES,
			V_APURA_ICMS.ALIQ_SIMPLES,
			V_APURA_ICMS.VLR_ICMS_SIMPLES,
			ISNULL(EST_PROD_CPL.VLR_CUSTO_MD,0 )VLR_CUSTO_MD,
			ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) VLR_ICMS_DESONERADO_IT,
			ISNULL(EST_NF_ENT.VLR_FECOP_ST,0)VLR_FECOP_ST,
			ISNULL(EST_NF_ENT.VLR_FECOP_ST_RET,0 )VLR_FECOP_ST_RET,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP,0 )VLR_FECOP_IT,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP_ST,0 )VLR_FECOP_ST_IT,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP_RET,0 )VLR_FECOP_ST_RET_IT,
			ISNULL(EST_PROD.NR_SERV,'') AS NR_SERV,
			ISNULL(FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) FLAG_VLR_ICMS_DESONERADO_DESCONTO,
			ISNULL(VLR_ICMS_RET,0) AS VLR_ICMS_RET_IT

	   FROM DBO.EST_NF_ENT  
		   INNER JOIN #FILIAIS FL ON DBO.EST_NF_ENT.CD_EMP = FL.CD_EMP
								 AND DBO.EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL
		   INNER JOIN DBO.EST_NF_ENT_IT ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
									AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
									AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
									AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT 
		   INNER JOIN DBO.EST_PROD ON DBO.EST_PROD.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
								AND DBO.EST_PROD.CD_PROD = DBO.EST_NF_ENT_IT.CD_PROD 
		   INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
		   INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
								    AND DBO.EST_NF_ENT.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE
		   LEFT JOIN V_APURA_ICMS ON EST_NF_ENT.CD_EMP = V_APURA_ICMS.CD_EMP
								AND EST_NF_ENT.CD_FILIAL = V_APURA_ICMS.CD_FILIAL
								AND EST_NF_ENT.CD_NF = V_APURA_ICMS.CD_NF
								AND V_APURA_ICMS.TIPO = 0
		   INNER JOIN EST_PROD_CPL ON EST_NF_ENT_IT.CD_EMP = EST_PROD_CPL.CD_EMP
								AND EST_NF_ENT_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
								AND EST_NF_ENT_IT.CD_PROD = EST_PROD_CPL.CD_PROD
		   INNER JOIN DBO.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON EST_PROD.CD_EMP = ARV.CD_EMP
													    AND EST_PROD.CD_PROD = ARV.CD_PROD
		   INNER JOIN DBO.EST_ARV_MERC_LINHA AS LINHA ON ARV.CD_EMP = LINHA.CD_EMP
											    AND ARV.CD_ARV_MERC_LINHA = LINHA.CD_ARV_MERC_LINHA
		   LEFT JOIN V_EST_NF_ENT_IMPOSTOS_PIS_COFINS ON V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_EMP = EST_NF_ENT.CD_EMP
				  AND V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_FILIAL = EST_NF_ENT.CD_FILIAL
				  AND V_EST_NF_ENT_IMPOSTOS_PIS_COFINS.CD_NF = EST_NF_ENT.CD_NF
		   LEFT JOIN EST_PROD_PRECO ON EST_PROD_PRECO.CD_EMP = EST_NF_ENT_IT.CD_EMP
								 AND EST_PROD_PRECO.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
								 AND EST_PROD_PRECO.CD_PROD = EST_NF_ENT_IT.CD_PROD
		   INNER JOIN EST_NF_ENT_DAR_IT ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP
									AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL
									AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DAR_IT.CD_NF
									AND EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_DAR_IT.CD_PROD
		   INNER JOIN DBO.EST_TRIB TRIB_DARE ON DBO.EST_NF_ENT_DAR_IT.CD_TRIB = TRIB_DARE.CD_TRIB
		   INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_ENT_DAR_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP		   
		   INNER JOIN EST_NF_ENT_DAR ON EST_NF_ENT_DAR.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP
								  AND EST_NF_ENT_DAR.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL
								  AND EST_NF_ENT_DAR.CD_NF = EST_NF_ENT_DAR_IT.CD_NF
		   LEFT JOIN EST_NF_ENT_EF_NF_CTR_NF ON EST_NF_ENT_EF_NF_CTR_NF.CD_EMP = EST_NF_ENT.CD_EMP
										AND EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL = EST_NF_ENT.CD_FILIAL
										AND EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT = EST_NF_ENT.CD_NF
		   LEFT JOIN V_EST_NF_ENT_NFE_SPED ON V_EST_NF_ENT_NFE_SPED.CD_EMP = EST_NF_ENT.CD_EMP
									   AND V_EST_NF_ENT_NFE_SPED.CD_FILIAL = EST_NF_ENT.CD_FILIAL
									   AND V_EST_NF_ENT_NFE_SPED.CD_NF = EST_NF_ENT.CD_NF
		   INNER JOIN GLB_USU ON EST_NF_ENT.CD_USU = GLB_USU.CD_USU
		   LEFT JOIN GLB_CID ON EST_NF_ENT.CD_CID_DESTINATARIO = GLB_CID.CD_CID
		   LEFT OUTER JOIN GLB_CID_GLB_MUNICIPIO ON GLB_CID.CD_CID = GLB_CID_GLB_MUNICIPIO.CD_CID
		   LEFT OUTER JOIN GLB_MUNICIPIO ON GLB_CID_GLB_MUNICIPIO.CD_MUNICIPIO = GLB_MUNICIPIO.CD_MUNICIPIO
		   LEFT JOIN EST_NF_ENT_CANCEL ON EST_NF_ENT_CANCEL.CD_EMP = EST_NF_ENT.CD_EMP
								    AND EST_NF_ENT_CANCEL.CD_FILIAL = EST_NF_ENT.CD_FILIAL
								    AND EST_NF_ENT_CANCEL.CD_NF = EST_NF_ENT.CD_NF
		   LEFT JOIN EST_NF_ENT_NFE_CANCEL ON EST_NF_ENT_CANCEL.CD_EMP = EST_NF_ENT_NFE_CANCEL.CD_EMP
									   AND EST_NF_ENT_CANCEL.CD_FILIAL = EST_NF_ENT_NFE_CANCEL.CD_FILIAL
									   AND EST_NF_ENT_CANCEL.CD_NF = EST_NF_ENT_NFE_CANCEL.CD_NF
		   LEFT JOIN EST_NF_ENT_DENEGADA ON EST_NF_ENT.CD_EMP = EST_NF_ENT_DENEGADA.CD_EMP
									 AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DENEGADA.CD_FILIAL
									 AND EST_NF_ENT.CD_NF = EST_NF_ENT_DENEGADA.CD_NF
		   LEFT JOIN EST_NF_SAI_NF_ENT ON EST_NF_ENT.CD_EMP = EST_NF_SAI_NF_ENT.CD_EMP
								    AND EST_NF_ENT.CD_FILIAL = EST_NF_SAI_NF_ENT.CD_FILIAL
								    AND EST_NF_ENT.CD_NF = EST_NF_SAI_NF_ENT.CD_NF_ENT 
	   WHERE 
			EST_NF_ENT.CD_EMP = 1 
		    AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM

------------------------------------------------------------------------------------------------------------
	   UPDATE SPED SET 
			CGC_CPF=V_GLB_PESSOA.CGC_CPF,
			NOME_PART = ISNULL(V_GLB_PESSOA.RAZAO_SOCIAL_PESSOA, ''),
			ENDERECO=ISNULL(V_GLB_PESSOA.ENDERECO_PESSOA, '') ,
			BAIRRO= ISNULL(V_GLB_PESSOA.BAIRRO_ENDERECO_PESSOA, ''),
			NUMERO= ISNULL(V_GLB_PESSOA.NUMERO_ENDERECO_PESSOA, ''),
			INSC_EST = ISNULL(V_GLB_PESSOA.INSC_EST, '') ,
			UF=ISNULL(V_GLB_PESSOA.UF, '') ,
			TEL= ISNULL(V_GLB_PESSOA.TELEFONE_PESSOA, '') ,
			CEP = ISNULL(V_GLB_PESSOA.CEP_ENDERECO_PESSOA, '') ,
			PART_FLAG_MICRO_EMPRESA =ISNULL(V_GLB_PESSOA.FLAG_SIMPLES_NACIONAL, 0),
			COD_IBGE = ISNULL(V_GLB_PESSOA.COD_IBGE_MUNICIPIO,'')
			--FLAG_NAO_ABATER_ICMS_DESONERADO = ISNULL(V_GLB_PESSOA.FLAG_NAO_ABATER_ICMS_DESONERADO,0 ) 			
	   FROM #V_SPED_NF_ENT SPED
		    JOIN V_GLB_PESSOA ON SPED.CD_EMP = V_GLB_PESSOA.CD_EMP
		AND SPED.CD_ORIG = V_GLB_PESSOA.CD_PESSOA
		AND SPED.DEST_ORIG = V_GLB_PESSOA.DEST_ORIG
------------------------------------------------------------------------------------------------------------
 
  SELECT * FROM #V_SPED_NF_ENT

 